// To parse this JSON data, do
//
//     final userModel = userModelFromJson(jsonString);

class UserModel {
  int id;
  String firstName;
  String lastName;
  String? niceName;
  String? phoneNumber;
  String email;
  String? sex;
  String? avatar;
  String status;
  String apiToken;
  double avgRating;

  UserModel({
    required this.id,
    required this.firstName,
    required this.lastName,
    this.niceName,
    this.phoneNumber,
    required this.email,
    this.sex,
    this.avatar,
    required this.status,
    required this.apiToken,
    required this.avgRating,
  });

  factory UserModel.fromJson(Map<String, dynamic> json) => UserModel(
        id: json["id"],
        firstName: json["first_name"],
        lastName: json["last_name"],
        niceName: json["nice_name"],
        phoneNumber: json["phone_number"],
        email: json["email"],
        sex: json["sex"],
        avatar: json["avatar"],
        status: json["status"],
        apiToken: json["api_token"],
        avgRating: double.tryParse(json["avg_rating"] == null
                ? "0"
                : json["avg_rating"].toString()) ??
            0,
      );

  Map<String, dynamic> toJson() => {
        "first_name": firstName,
        "last_name": lastName,
        "nice_name": niceName,
        "phone_number": phoneNumber,
        "email": email,
        "sex": sex,
        "avatar": avatar,
        "status": status,
        "api_token": apiToken,
        "avg_rating": avgRating,
      };

  Map<String, dynamic> toMap() => {
        "first_name": firstName,
        "last_name": lastName,
        if (niceName != null) "nice_name": niceName,
        if (phoneNumber != null) "phone_number": phoneNumber,
        "email": email,
        if (sex != null) "sex": sex,
        if (avatar != null) "avatar": avatar,
      };
}
